local TABAS_TfcBase = require("TABAS_TfcBase")
local TABAS_Utils = require("TABAS_Utils")

local TABAS_TfcBathtub = TABAS_TfcBase:derive("TABAS_TfcBathtub")

function TABAS_TfcBathtub:getLinkedBathObject()
    if not self.linkedBathObject then return nil end
    return self.linkedBathObject
end

function TABAS_TfcBathtub:getLinkedSquare()
    if not self.linkedSquare then return nil end
    return self.linkedSquare
end

function TABAS_TfcBathtub:addLinked(square)
    local facing = self.facing
    local dir
    if facing == "S" then dir = IsoDirections.S end
    if facing == "E" then dir = IsoDirections.E end
    if facing == "N" then dir = IsoDirections.N end
    if facing == "W" then dir = IsoDirections.W end
    self.linkedSquare = square:getAdjacentSquare(dir)
    self.linkedBathObject = TABAS_Utils.getBathObjectOnSquare(self.linkedSquare, self.facing)
end


function TABAS_TfcBathtub:initNew()
    self:setSpritesTable("spritesTable", "BathWater", "faucet")
    self:setSpritesTable("linkedSprites", "BathWater", "tub")
    self:addLinked(self.square)
end

function TABAS_TfcBathtub:new(x, y, z, facing)
    local o = TABAS_TfcBase.new(self, x, y, z, facing)
    if not o then return nil end

    if not o.linkedBathObject or (o.tfcObject and not o.linkedTfcObject) or (not o.tfcObject and o.linkedTfcObject) then
        o:remove()
        return nil
    end

    return o
end

return TABAS_TfcBathtub